#include <stdlib.h>
#include <string.h>
#include <SupportDefs.h>
#include <OS.h>
#include <Drivers.h>
#include <KernelExport.h>
#include <malloc.h>

#ifdef __cplusplus
extern "C" {
#endif

int32	api_version = B_CUR_DRIVER_API_VERSION;
char                *pci_name = B_PCI_MODULE_NAME;
pci_module_info     *pci; 
pci_info 			info;
void 				*settings;

static device_hooks  device_hooks =  {
	driver_open, 			/* -> open entry point */
	driver_close,			/* -> close entry point */
	driver_free,			/* -> free entry point */
	driver_control, 		/* -> control entry point */
	driver_read,			/* -> read entry point */
	driver_write,			/* -> write entry point */
	driver_select,			/* -> select entry point */
	driver_deselect			/* -> deselect entry point */
};

struct pciCompare
{
	ushort vendor_id;
	ushort device_id;
	uchar revision;
	uchar class_api;
	uchar class_sub;
	uchar class_base;
};

int convertDriverParameter(pciCompare *populate,driver_parameter parm)
{
	if ((parm.value_count==6) && (!strcmp(parm.name,"PCI_Settings")))
		{
		populate.vendor_id=atoi(parm.values[0]);
		populate.device_id=atoi(parm.values[1]);
		populate.revision=atoi(parm.values[2]);
		populate.class_api=atoi(parm.values[3]);
		populate.class_sub=atoi(parm.values[4]);
		populate.class_base=atoi(parm.values[5]);
		return 1;
		}
	return 0;	
}

void readCompares(pciCompare *cmps,int *found,driver_parameter *search )
{
	for (int decents=search->parameter_count;decents>=0;decents--)
		{
		readCompares(cmps,found,search->parameters[decents])
		convertDriverParameter(&(cmps[found]),search);
		}
}

// This function has a side effect that it leaves info populated, if it is valid.
status_t automatedDetect(void)
{
	bool done=false;
	int cardNo=0;
	// Get the different configs to check
	// Since these are only 8 bytes, just allocate 50 of them rather than some dynamic scheme
	pciCompare compares[50]; 
	int count=0;
	
	int maxCompare=readCompares(compares,&count,(get_driver_settings(settings))->parameter);	
	// Check the configs
	while (!done)
		{
		if ((*pci->get_nth_pci_info)(cardNo, &info) != B_NO_ERROR)
			{
			done=true;
			cardNo=-1;
			memset(&info,0,sizeof(info));
			}
		else
			{// Check this card against all configs
			bool match=true; 
			for (int thisCompare=0;thisCompare<maxCompare;thisCompare++)
				{
				if ((compares[thisCompare].vendor_id) && (compares[thisCompare].vendor_id!=info.vendor_id)) match=false;
				if ((compares[thisCompare].device_id) && (compares[thisCompare].device_id!=info.device_id)) match=false;
				if ((compares[thisCompare].revision) && (compares[thisCompare].revision!=info.revision)) match=false;
				if ((compares[thisCompare].class_api) && (compares[thisCompare].class_api!=info.class_api)) match=false;
				if ((compares[thisCompare].class_sub) && (compares[thisCompare].class_sub!=info.class_sub)) match=false;
				if ((compares[thisCompare].class_base) && (compares[thisCompare].class_base!=info.class_base)) match=false;
				}
			done=match; // If a match was found, we are done.
			cardNo++;
			}
		}
	return (cardNo>0);
}

status_t init_hardware()
{
	settings=load_driver_settings(DRIVER_NAME);	
	bool automatedDetection=get_driver_boolean_parameter(settings,"autoDetect",false,false);
	bool needPCI=get_driver_boolean_parameter(settings,"needPCI",false,false);
	ddprintf("init_hardware - %s\n",DRIVER_NAME);
	if (needPCI)
		{
		get_module(pci_name, (module_info **)&pci);
		if (automatedDetection)
			return automatedDetect();	
		}
	return (driver_init_hardware(void));
}

status_t init_driver()
{
	ddprintf("init_driver - %s\n",DRIVER_NAME);
	return (driver_init_driver(void));
}

void uninit_driver()
{
	ddprintf("uninit_driver - %s\n",DRIVER_NAME);
}

const char ** publish_devices()
{
	ddprintf("publish_device - %s\n",DRIVER_NAME);
	return device_list;
}

device_hooks * find_device(const char *name)
{
	ddprintf("find_device - %s\n",DRIVER_NAME);
	return &device_hook;
}

#ifdef __cplusplus
}
#endif
